using System.Collections;
using System.Collections.Generic;
using Godot;
using System;

using System.Threading.Tasks;
using System.Linq;

namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class GridSubDivider:MeshAxisSubDivider
  {
    [Export]
    public int numSubDivisions = 1;

    public override List<float> GetSubDivisions( Transform3D quadTransform, Axis axis )
    {
      var list = new List<float>();

      for ( int i = 0; i < numSubDivisions; i++ )
      {
        float s = (float)( i + 1f ) / (float)( numSubDivisions + 1f );
      }

      return list;
    } 
  }
}