using System.Collections;
using System.Collections.Generic;
using Godot;
using System;

using System.Threading.Tasks;
using System.Linq;

namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class ManualAbsoluteSubDivider:MeshAxisSubDivider
  {
    public enum SourceAxis
    {
      X,
      Y,
      Z
    } 

    [Export]
    public SourceAxis sourceAxis;

    [Export]  
    public float[] subDivisions;

    public override List<float> GetSubDivisions( Transform3D quadTransform, Axis axis )
    {      
      var min = GetWorldMin( quadTransform );
      var max = GetWorldMax( quadTransform );

      var minV = min.X;
      var maxV = max.X;

      if ( SourceAxis.Y == sourceAxis )
      {
        minV = min.Y;
        maxV = max.Y;
      }
      if ( SourceAxis.Z == sourceAxis )
      {
        minV = min.Z;
        maxV = max.Z;
      }

      var list = new List<float>();

      for ( int i = 0; i < subDivisions.Length; i++ )
      {
        var mapped = MathX.Normalize( list[ i ], minV, maxV ); 

        if ( mapped <= 0 || mapped >= 1 )
        {
          continue;
        }

        list.Add( mapped );
      }

      return list;
    } 
  }
}