using System.Collections;
using System.Collections.Generic;
using Godot;
using System;

using System.Threading.Tasks;
using System.Linq;

namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class MeshAxisSubDivider:Resource
  {
    public enum Axis
    {
      U,
      V      
    }

    public virtual List<float> GetSubDivisions( Transform3D quadTransform, Axis axis )
    {
      return new List<float>();
    } 

    public Vector3 GetWorldMin( Transform3D worldTransform )
    {
      return worldTransform * new Vector3( -0.5f, -0.5f, 0.0f);
    }

     public Vector3 GetWorldMax( Transform3D worldTransform )
    {
      return worldTransform * new Vector3( 0.5f, 0.5f, 0.0f);
    }

    public Vector3 AxisToVector( Axis a, float t = 1)
    {
      var d = Mathf.Lerp( -0.5f, 0.5f, t );
      var v = Axis.U == a ? new Vector3( d, 0, 0 ) : new Vector3( 0, d, 0 );

      return v;
    }

    public static List<float> GetSubDivisions( MeshAxisSubDivider divider, Transform3D quadTransform, Axis axis )
    {
      if ( divider == null )
      {
        return new List<float>(){};
      }
      
      return divider.GetSubDivisions( quadTransform, axis );
    }

    public static List<float> GetSubDivisionsU( MeshAxisSubDivider divider, Transform3D quadTransform )
    {
      return GetSubDivisions( divider, quadTransform, Axis.U );
    }

    public static List<float> GetSubDivisionsV( MeshAxisSubDivider divider, Transform3D quadTransform )
    {
      return GetSubDivisions( divider, quadTransform, Axis.V );
    }
    
  }
}