using System.Collections;
using System.Collections.Generic;
using Godot;
using System;



namespace Rokojori
{
  public class OctahedralMapping
  {
    public static Vector3 Hemisphere( Vector2 uv )
    {
      var position = new Vector3 (uv.X - uv.Y, 0, -1.0f + uv.X + uv.Y );
      var absolute = position.Abs();
      position.Y = 1.0f - absolute.X - absolute.Z;

      return position;
    }

    public static Vector3 Sphere( Vector2 uv )
    {
      uv = uv * 2.0f - Vector2.One;
      var position = new Vector3( uv.X, 0, uv.Y );
      var absolute = position.Abs();
      position.Y = 1.0f - absolute.X - absolute.Z;

      if ( position.Y < 0 )
      {
        var sign = position.Sign();
        position.X = sign.X * ( 1.0f - absolute.Z );
        position.Z = sign.Z * ( 1.0f - absolute.X );
      }

      return position;
    }

    public static Vector3 Map( Vector2 uv, bool sphere )
    {
      var position = sphere ? Sphere( uv ) : Hemisphere( uv );

      return position.Normalized();
    }
  }
}
