using System.Collections;
using System.Collections.Generic;
using Godot;
using System;

using System.Threading.Tasks;

namespace Rokojori
{
  [Tool][GlobalClass]
  public partial class _XX_MultiBakeModeBillboardBase:_XX_MultiBakeMode
  {
    [Export]
    public bool useDoubleSidedMaterial = false;

    public override void CreateMaterial( List<_XX_BakingPass> passes )
    {
      var preview = passes.Find( p => p.ContainsBakingOutput( BakingTargetType.Albedo ) ) == null;

      var mb = multiBaker;

      var material = new StandardMaterial3D();
      
      material.ShadingMode = preview ? BaseMaterial3D.ShadingModeEnum.Unshaded : BaseMaterial3D.ShadingModeEnum.PerPixel;
      material.Transparency = BaseMaterial3D.TransparencyEnum.AlphaScissor;
      material.AlphaScissorThreshold = 0.01f;
      material.AlphaAntialiasingMode = BaseMaterial3D.AlphaAntiAliasing.AlphaToCoverageAndToOne;
      material.AlphaAntialiasingEdge = 0.95f;
      material.NormalEnabled = ! preview;

      if ( useDoubleSidedMaterial )
      {
        material.CullMode = BaseMaterial3D.CullModeEnum.Disabled;
      }

      MaterialSurfaceContainer.SetMaterialInSlot( mb.X_outputMesh, MaterialSlot.MeshSurface, material );

      // Materials.Set( mb.X_outputMesh, material );   
    }

    public override void AssignMaterial( List<_XX_BakingPass> passes )
    {
      var mb = multiBaker;
      // var material = Materials.Get<StandardMaterial3D>( mb.X_outputMesh );
      var material = MaterialSurfaceContainer.GetMaterialInSlot<StandardMaterial3D>( mb.X_outputMesh, MaterialSlot.MeshSurface );     


      material.AlbedoTexture = _XX_BakingPass.Get( passes, BakingTargetType.Albedo, BakingTargetType.Lit );     
      material.NormalTexture = _XX_BakingPass.Get( passes, BakingTargetType.Normals );   
      
      
      material.AOTexture    = _XX_BakingPass.Get( passes, BakingTargetType.ORM );   
      material.RoughnessTexture    = _XX_BakingPass.Get( passes, BakingTargetType.ORM );   
      material.MetallicTexture    = _XX_BakingPass.Get( passes, BakingTargetType.ORM );   
      material.AOEnabled = true;

      material.AOLightAffect = 1;

      material.AOTextureChannel = BaseMaterial3D.TextureChannel.Red;
      material.RoughnessTextureChannel = BaseMaterial3D.TextureChannel.Green;
      material.MetallicTextureChannel = BaseMaterial3D.TextureChannel.Blue;

      material.MetallicSpecular = 0;

      // material.Anisotropy = 1;
      // material.AnisotropyEnabled = true;
      material.TextureFilter = BaseMaterial3D.TextureFilterEnum.LinearWithMipmapsAnisotropic;

    }
  }
}