using System.Collections;
using System.Collections.Generic;
using Godot;
using System;
using System.Linq;
using System.Threading.Tasks;



namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class PixelDensityTool:Node
  { 
    [Export]
    public float fovDegrees = 60;

    [Export]
    public Vector2 screenSize = new Vector2( 1920, 1080 );

    [Export]
    public float startDistance = 1;

    [Export]
    public float endDistance = 4000;

    [Export]
    public int numEntries = 20;

    [Export]
    public float densityTablePower = 2;



    [ExportToolButton( "Compute Pixel Density Tables")]
    public Callable ExecuteButton => Callable.From( () => 
    {
      var list = new List<string>();
      for ( int i = 0; i < numEntries; i++ )
      {
        var t = i / ( float ) ( numEntries - 1f );
        t = Mathf.Pow( t, densityTablePower );        
        var distance = Mathf.Lerp( startDistance, endDistance, t );

        var pixelDensity = Cameras.ComputePixelDensityVertical( fovDegrees, distance, screenSize );
        var minSize = 1f / pixelDensity;

        list.Add( "[" + distance._M()+ "] density: " + pixelDensity._FF() + "px/m  -  size:" + ( minSize < 1 ? minSize._CM() :  minSize._M() ) + " " );

      }

      distanceToPixelSize = list.ToArray();
    } 
    );

    [Export]
    public string[] distanceToPixelSize;

  } 
}