using System.Collections;
using System.Collections.Generic;
using Godot;
using System;



namespace Rokojori
{
  public static class Textures
  {    

    public static Texture2D Copy( Texture2D original )
    {
      return ImageTexture.CreateFromImage( original.GetImage() );
    }

    public static void Save( Viewport viewport, string path, float quality = 0.75f )
    {
      Save( viewport.GetTexture(), path, quality );
    }

    public static void Save( Texture2D texture, string path, float quality = 0.75f )
    {
      Save( texture.GetImage(), path, quality );
    }

    public static void Save( Image image, string path, float quality = 0.75f )
    {
      var fp = FilePath.Absolute( path );

      var output = ".png";

      if ( 
        fp.HasFileExtension( ".jpg" ) ||
        fp.HasFileExtension( ".exr" ) ||
        fp.HasFileExtension( ".webp" )
      )
      {
        output = fp.fileExtension;
      }

      switch ( output )
      {
        case ".jpg": 
        { 
          image.SaveJpg( path, quality ); 
        }
        break;

        case ".png": 
        { 
          image.SavePng( path ); 
        }
        break;

        case ".webp": 
        { 
          image.SaveWebp( path, quality < 1, quality ); 
        }
        break;

        case ".exr": 
        { 
          image.SaveExr( path ); 
        }
        break;
      }
    }


  }
}