using System.Collections;
using System.Collections.Generic;
using Godot;
using System;



namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class AutoDistance_BakingFDSettings:_XX_BakingFDSettings
  {
    [Export]
    public float fov = 75;

    [Export]
    public float zoom = 1;

    [Export]
    public SizeEstimationType sizeEstimation = SizeEstimationType.Bounding_Sphere;

    [Export]
    public float sizeAbsoluteOffset = 0;

    [Export]
    public float sizeRelativeOffset = 0.1f;


    public override Vector2 ComputeFOVDistance( float size )
    {
      size += sizeAbsoluteOffset;
      size += sizeRelativeOffset * size;

      var distance = Cameras.ComputeCameraFrameFittingDistance( fov, size / zoom );
      
      return new Vector2( fov, distance );
    }
  }
}