using System.Collections;
using System.Collections.Generic;
using Godot;
using System;



namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class AutoFOVDistance_BakingFDSettings:_XX_BakingFDSettings
  {
    [Export]
    public float gameCameraFOV = 75;

    [Export]
    public float gameViewDistance = 10;

    [Export]
    public float zoom = 1;

    [Export]
    public SizeEstimationType sizeEstimation = SizeEstimationType.Bounding_Sphere;

    [Export]
    public float sizeAbsoluteOffset = 0;

    [Export]
    public float sizeRelativeOffset = 0.1f;


    public override Vector2 ComputeFOVDistance( float size )
    {            
      size += sizeAbsoluteOffset;
      size += sizeRelativeOffset * size;

      var fov = Cameras.ComputeFOVForBillboard( gameCameraFOV, size, gameViewDistance );
      var distance = Cameras.ComputeCameraFrameFittingDistance( fov, size / zoom );
      

      return new Vector2( fov, distance );
    }
  }
}