using System.Collections;
using System.Collections.Generic;
using Godot;
using System;



namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class Manual_BakingFDSettings:_XX_BakingFDSettings
  {
    [Export]
    public float cameraDistance = 10;

    [Export]
    public float cameraFOV = 75;

    public override Vector2 ComputeFOVDistance( float size )
    {            
      return new Vector2( cameraFOV, cameraDistance );
    }

    public static Manual_BakingFDSettings Create( float fov, float distance )
    {
      var m = new Manual_BakingFDSettings();
      m.cameraDistance = distance;
      m.cameraFOV = fov;
      return m;
    }
  }
}