using System.Collections;
using System.Collections.Generic;
using Godot;
using System;



namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class LODMultiMeshInstance3D:MultiMeshInstance3D
  {
    [Export]
    public float cullDistance = 5000;

    [Export]
    public float cullRange = 2000;

    [Export]
    public Curve cullCurve = MathX.Curve( 0, 1 );

    public override void _Process( double delta )
    {
      var camera = GetViewport().GetCamera3D();

#if TOOLS 

      if ( Engine.IsEditorHint() )
      {
        camera = EditorInterface.Singleton.GetEditorViewport3D().GetCamera3D();
      }
       
#endif

      var distance = ( camera.GlobalPosition - GlobalPosition ).Length();

      var cullAmount = MathX.NormalizeClamped( distance, cullDistance - cullRange, cullDistance );
      cullAmount = cullCurve == null ? cullAmount : cullCurve.Sample( cullAmount );

      Multimesh.VisibleInstanceCount = Mathf.RoundToInt( Multimesh.InstanceCount  * ( 1.0 - cullAmount ) );

    }
  }
}