using System.Collections;
using System.Collections.Generic;
using Godot;
using System;



namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class NormalBlenderSettings:Resource
  {
    public enum Mode
    {
      Over_Y
    }
    [Export]
    public Mode mode;

    [Export(PropertyHint.Range,"0,1")]
    public float normalBlendAmount = 0.5f;

    [ExportGroup("Over Y")]
    [Export]
    public Vector3 overY_blendDirection = Vector3.Up;

    [Export]
    public float overY_blendStartY = 0;

    [Export]
    public float overY_blendEndY = 0.25f;

    [Export]
    public Curve overY_blendCurve;

    
    public MeshGeometry Blend( MeshGeometry mg )
    {
      if ( Mode.Over_Y == mode )
      {
        return BlendOverY( mg );
      }

      return mg;
    }

    MeshGeometry BlendOverY( MeshGeometry mg )
    {
      mg.BlendNormalsOverY( overY_blendDirection, normalBlendAmount, overY_blendStartY, overY_blendEndY, overY_blendCurve );
      return mg;
    }

  }
}