using System.Collections;
using System.Collections.Generic;
using Godot;
using System;



namespace Rokojori
{
  public class VertexAttributes
  {
    public Vector3 position;
    public Vector3? normal;
    public Vector2? uv;
    public Vector2? uv2 = null;
    public Color? color = null;

    public static VertexAttributes Create( Vector3 position, Vector2 uv, Vector3 normal )
    {
      var va = new VertexAttributes();
      va.position = position;
      va.uv = uv;
      va.normal = normal;
      return va;
    }

    public VertexAttributes Lerp( VertexAttributes other, float t )
    {
      var lerped = new VertexAttributes();

      lerped.position = position.Lerp( other.position, t );

      if ( normal != null )
      {
        lerped.normal = ((Vector3)normal).Lerp( (Vector3)other.normal, t );
      }

      if ( uv != null )
      {
        lerped.uv = ((Vector2)uv).Lerp( (Vector2)other.uv, t );
      }

      if ( uv2 != null )
      {
        lerped.uv2 = ((Vector2)uv2).Lerp( (Vector2)other.uv2, t );
      }

      if ( color != null )
      {
        lerped.color = ((Color)color).Lerp( (Color)other.color, t );
      }     

      return lerped;

    }
  }
}