using System.Collections;
using System.Collections.Generic;
using Godot;
using System;



namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class SingleQuadBillboard:QuadBillboardDataProcessor
  { 
    TransformChange transformChange = new TransformChange();

   
    public override void _Process( double delta )
    {
      var changed = transformChange.Check( this );

      if ( changed )
      {
        IncrementUpdateID();
      }
    }
    

    public override List<QuadBillboardData> Process( List<QuadBillboardData> data )
    {
      var parent = GetParent<QuadBillboardMeshGenerator>();
      var d = new QuadBillboardData();
      d.position = GlobalPosition - parent.GlobalPosition;
      d.rotation = this.GlobalQuaternion();
      d.scale    = Scale;
      d.visible = true;

      data.Add( d );
      return data;
    }
  }
}