
using Godot;
using Rokojori;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class TubeGeometrySettings:Resource
  {   
    [Export]
    public TubeSegmentMode segmentMode = TubeSegmentMode.Fixed_Division;    
    [Export]
    public bool useFullUVQuads = false;    
    [Export]
    public int fixedSplineSegmentDivisions = 20;
    [Export]
    public float splineSegmentLength = 2;    
    [Export]
    public bool undistortSplineSegments = true;    
    [Export]
    public Curve twistCurve;    
    [Export]
    public float radius = 1f;    
    [Export]
    public int radialSegments = 8;   
    [Export] 
    public Curve radiusSizeCurve;    
    [Export]
    public Curve radiusWidthCurve;    
    [Export]
    public Curve radiusHeightCurve;    
    [Export]
    public bool scaleRadiusByPathTransforms = true;

    public enum CapType
    {
      None,
      Flat,
      Half_Sphere
    }

    [Export]
    public CapType startCapType;

    [Export]
    public Vector2 startCapUVMin =Vector2.Zero;

    [Export]
    public Vector2 startCapUVMax =Vector2.One;

    [Export]
    public CapType endCapType;

    [Export]
    public Vector2 endCapUVMin =Vector2.Zero;

    [Export]
    public Vector2 endCapUVMax =Vector2.One;

  }
}