using System.Collections;
using System.Collections.Generic;
using Godot;
using System;



namespace Rokojori
{
  public class PointData
  {
    public bool visible = false;
    public Vector3 position = Vector3.Zero;
    public bool useGlobalPosition = true;
    public Quaternion rotation = Quaternion.Identity;
    public bool useGlobalRotation = true;
    public Vector3 scale = Vector3.One;
    public int seed;
    public Node3D parent;

    public Vector3 globalPosition => useGlobalPosition || parent == null ? 
                                  position : parent.ToGlobal( position );

    public Quaternion globalRotation => useGlobalRotation || parent == null ? 
                                        rotation : parent.GlobalQuaternion() * rotation;

    
    public Vector3 globalScale => parent == null ? scale : parent.Scale * scale;

    public Transform3D globalTransform3D
    {
      get 
      {
        return Math3D.TRS( globalPosition, globalRotation, globalScale );
      }
    }



    public void ApplyTransform( Node3D node3D )
    {
      if ( useGlobalPosition )
      {
        node3D.GlobalPosition = position;
      }
      else
      {
        node3D.Position = position;
      }

      if ( useGlobalRotation )
      {
        Math3D.SetGlobalRotationTo( node3D, rotation.GetNormalized() );
      }
      else
      {
        node3D.Quaternion = rotation.GetNormalized();
      }

      node3D.Scale = scale;     
    }
  }
}