using System.Collections;
using System.Collections.Generic;
using Godot;
using System;



namespace Rokojori
{
  public enum DiscardNoiseOwnPositionMode
  {
    Ignore,
    Add_Global,
    Add_Local
  }

  [Tool]
  [GlobalClass]
  public partial class DiscardNoise:Discarder
  {    
    [Export(PropertyHint.Range, "0,1")]
    public float insideTreshold = 0.5f;

    [Export]
    public float noiseScale = 1;

    [Export]
    public Vector3 noiseOffset = Vector3.Zero;

    [Export]
    public ScattererOwnPositionMode ownPositionMode = ScattererOwnPositionMode.Ignore;

    public override bool IsInside( Vector3 position )
    {
      var offset = noiseOffset + ScattererOwnPosition.ComputeOffset( ownPositionMode, this );

      var value = Noise.Perlin( ( position - offset ) * noiseScale );

      return value < insideTreshold;
    }
   
  }
}