using System.Collections;
using System.Collections.Generic;
using Godot;
using System;



namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class DiscardSpline:Discarder
  {    
    [Export]
    public Spline spline;
    
    [Export]
    public float size;

    [Export]
    public bool xzOnly = false;

    [Export]
    public bool asFilledXZPath = false;
   
    public override bool IsInside( Vector3 position )
    {
      if ( asFilledXZPath )
      {        
        var bounds = spline.GetBounds().AsXZBox2();
        bounds.GrowRelativeToSize( 1/3f );

        var p2 = Math2D.XZ( position ); 

        if ( bounds.ContainsPoint( p2 ) )
        {
          //var path = spline.GetXZPath2();
          var cg = spline.GetConvex2Group();
          var insideGroup = cg.ContainsPoint( p2 );
         // var insidePath = insideGroup || path.PointInPath( p2, fastButUnreliableFilledXZPathChecks, false );

          if ( insideGroup )
          {
            return true;
          }
        }        
      }

      if ( size <= 0 )
      {
        return false;
      }

      var curve = xzOnly ? spline.GetCurveXZ() : spline.GetCurve();

      var testPosition = position;

      if ( xzOnly )
      {
        testPosition.Y = 0;
      }

      var distance = curve.GetDistanceTo( testPosition );

      return distance < size;
      
    }
   
  }
}