using System.Collections;
using System.Collections.Generic;
using Godot;
using System;



namespace Rokojori
{
  [Tool]
  public partial class Discarder:Scatterer
  {
    [Export]
    public DiscardMode mode;

    [Export]
    public DiscardBooleanCombinator combinator;

    [Export]
    public BooleanLogicBinaryOperator discordOperator;


    public virtual bool IsInside( Vector3 position )
    {
      return true;
    }

    protected override List<ScatterPoint> _Scatter( List<ScatterPoint> points, Scatterer root )
    { 
      points.ForEach( p => 
        {
          var inside = IsInside( p.globalPosition );
          var outside = ! inside;

          var visible = DiscardMode.DiscardInside  == mode && outside ||
                        DiscardMode.DiscardOutside == mode && inside;

          
          if ( DiscardBooleanCombinator.Overwrite == combinator )
          {
            p.visible = visible;
          }
          else
          {
            var result = BooleanLogic.Binary( discordOperator, p.visible, visible );
            p.visible = result;
          }

        }

      );

      return points;
    }

    
  }
}