using System.Collections;
using System.Collections.Generic;
using Godot;
using System;



namespace Rokojori
{
  public enum DiscardListMode
  {
    At_Least_Inside_One,
    Only_Inside_One,
    Must_Be_Inside_All
  }
  
  [Tool]
  [GlobalClass]
  public partial class DiscarderList:Discarder
  {
    [Export]
    public DiscardListMode listMode;

    [Export]
    public bool childrenNeedToBeVisible = true;
    [Export]
    public bool childrenNeedToBeProcessing = false;
    
    public override bool IsInside( Vector3 position )
    {
      var inside = 0;

      var numNodes = 0;

      Nodes.ForEachDirectChild<Discarder>( this,
        d => 
        {
          if ( ! IsChildEnabled( d, childrenNeedToBeVisible, childrenNeedToBeProcessing ) ) 
          {
            return;
          } 

          if ( d.IsInside( position ) )
          {
            inside ++;
          }

          numNodes++;
        }
      );

      if ( DiscardListMode.At_Least_Inside_One == listMode )
      {
        return inside > 0;
      }
      else if ( DiscardListMode.Only_Inside_One == listMode )
      {
        return inside == 1;
      }
      else if ( DiscardListMode.Must_Be_Inside_All == listMode )
      {
        return numNodes == inside;
      }

      return false;


    }

   
  }
}