using System.Collections;
using System.Collections.Generic;
using Godot;
using System;



namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class GeneratePinBoundary:GeneratorScatterer
  {
     [Export]
    public Spline spline;

    [Export]
    public bool xzOnly = true;

    [Export]
    public float sampleDensity;


    SplineCurve last;
    LerpCurve3 equalSpacedCurve;

    protected override List<ScatterPoint> _Scatter( List<ScatterPoint> points, Scatterer root )
    {
       var curve = spline.GetCurve();

      if ( last != curve )
      {
        last = curve;
        equalSpacedCurve = LerpCurve3.SampledEqually( curve, sampleDensity );
      }

      return points;
    }

    int CreatePoint( List<ScatterPoint> points, int id, float x, float y, float z )
    {
      var p = new ScatterPoint( this, id++ );

      p.position = new Vector3( x, y, z );      
      p.visible = ! setDiscarded;
      p.seed = Noise.CreateSeed( p.position );

      AssginSceneAndContainer( p );

      points.Add( p );

      return id;
    } 


  }
}