using System.Collections;
using System.Collections.Generic;
using Godot;
using System;



namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class GeneratorEntry:Node3D
  {
    [Export]
    public PackedScene packedScene;

    [Export]
    public Node3D node3D;

    [Export]
    public bool refreshNode3D = false;

    [Export]
    public bool getMeshInstanceChild = false;

    [ExportGroup("Instancing")]
    [Export]
    public bool useInstancing = false;

    [Export]
    public float instancingCullDistance = 1000;

    [Export]
    public float instancingCullRange = 500;

    [Export]
    public float instancingSplitSize = 25;

    [Export] 
    public Vector3 instancingSplitScatterNoiseAmount = Vector3.Zero;

    [Export] 
    public Vector3 instancingSplitScatterNoiseFrequency = Vector3.Zero;

    


    [ExportGroup("")]

    protected PackedScene _cachedNode3DScene;

    public PackedScene GetPackedScene()
    {
      if ( packedScene != null )
      {
        return packedScene;
      }

      if ( refreshNode3D || _cachedNode3DScene == null )
      {
        refreshNode3D = false;
        _cachedNode3DScene = new PackedScene();

        var node = node3D;

        if ( getMeshInstanceChild )
        {
          node = Nodes.GetAnyChild<MeshInstance3D>( node );
        }

        _cachedNode3DScene.Pack( node );
      }

      return _cachedNode3DScene; 
    }

    [Export]
    public float probability = 1;

    [Export]
    public Node3D container;

  }
}