using System.Collections;
using System.Collections.Generic;
using Godot;
using System;



namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class ScatterList:Scatterer
  { 
    [Export]
    public bool childrenNeedToBeVisible = true;
    [Export]
    public bool childrenNeedToBeProcessing = false;

    [Export]  
    public bool clearChildContainers = false;

    
    public override void _Process( double delta )
    {
      if ( clearCache )
      {
        clearCache = false;
        ClearCache();
      }
      
      if ( clearContainers )
      {
        clearContainers = false;
        ClearContainers();
      }

      if ( clearChildContainers )
      {
        clearChildContainers = false;
        Nodes.ForEachDirectChild<Scatterer>( this, s => s.ClearContainers() );       
      }

      if ( ! ( update || updateAlways ) )
      {
        return;
      }

      update = false;

      ScatterAndInstantiatePoints();
    }

    protected override List<ScatterPoint> _Scatter( List<ScatterPoint> points, Scatterer root = null )
    { 
      if ( root == null )
      {
        root = this;
      }

      var output = points;

      Nodes.ForEachDirectChild<Scatterer>( this,
        ( s )=>
        {
          if ( ! IsChildEnabled( s ) )
          {
            return;
          }

          var before = output.Count ;
          output = s.Scatter( output, root );
          // RJLog.Log( "Processed", before, "to", output.Count );
        }
      );

      return output;
    } 

    bool IsChildEnabled( Scatterer s )
    {
      return IsChildEnabled( s, childrenNeedToBeVisible, childrenNeedToBeProcessing );
    }

  }
}