using System.Collections;
using System.Collections.Generic;
using Godot;
using System;



namespace Rokojori
{
  public class ScatterPoint:PointData
  {
    public bool instanced = false;
    
    public float instanceCullDistance = 200;
    public float instanceCullRange = 100;

    public float instanceSplitSize = 25;
    public Vector3 instancingSplitScatterNoiseAmount = Vector3.Zero;
    public Vector3 instancingSplitScatterNoiseFrequency = Vector3.Zero;

    public GeometryInstance3D.ShadowCastingSetting shadowCasting = GeometryInstance3D.ShadowCastingSetting.On;
    protected Scatterer _creator;
    public Scatterer creator => _creator;
    protected int _creatorID;
    public int creatorID => _creatorID;
    
    
    public ScatterPoint( Scatterer creator, int id )
    {
      this._creator = creator;
      this._creatorID = id;
    }

   
    public PackedScene scene;

    public bool CanBeReusedBy( ScatterPoint other )
    {
      return parent == other.parent && scene == other.scene;
    }

    public void UpdateInstantiated( Node3D node )
    {
      ApplyTransform( node );
    }

    
    public Node3D Instantiate()
    {
      if ( ! visible || scene == null || parent == null )
      {
        return null;
      }

      var node3D = scene.Instantiate<Node3D>();
      
      parent.AddChild( node3D );
      node3D.Owner = parent.Owner;

      ApplyTransform( node3D );     

      return node3D;
    }

    
  }
}