using System.Collections;
using System.Collections.Generic;
using Godot;
using System;



namespace Rokojori
{
  public enum ScattererOwnPositionMode
  {
    Ignore,
    Add_Global,
    Add_Local
  }

  public class ScattererOwnPosition
  {
    public static Vector3 ComputeOffset( ScattererOwnPositionMode mode, Node3D n )
    {
      var offset = Vector3.Zero;

      if ( ScattererOwnPositionMode.Add_Global == mode )
      {
        offset += n.GlobalPosition;
      }

      if ( ScattererOwnPositionMode.Add_Local == mode )
      {
        offset += n.Position;
      }

      return offset;
    }
  }
}