using System.Collections;
using System.Collections.Generic;
using Godot;
using System;
using System.Threading.Tasks;


namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class TextureChanneMixelChannelSetting:Resource
  { 
    [Export]
    public bool isAssigned = true;

    [Export]
    public float notAssignedValue = 0;

    [Export]
    public bool output_sRGB = true;

    public enum ColorSource
    {
      Red, Green, Blue, Alpha
    }

    [Export]
    public ColorSource source_channel;

    [Export]
    public bool source_sRGB = true; 

    [Export]
    public Curve source_modifier;

    float GetChannel( Color color, ColorSource colorSource )
    {
      if ( ColorSource.Red == colorSource )
      {
        return color.R;
      }

      if ( ColorSource.Green == colorSource )
      {
        return color.G;
      }

      if ( ColorSource.Blue == colorSource )
      {
        return color.B;
      }

      if ( ColorSource.Alpha == colorSource )
      {
        return color.A;
      }

      return 0.0f;
    }

    public float GetValue( Color sourceColor )
    {
      if ( ! isAssigned )
      {
        return notAssignedValue;
      }

      var value = GetChannel( sourceColor, source_channel );

      if ( source_modifier == null && source_sRGB == output_sRGB )
      {
        return value;
      }

      if ( source_sRGB )
      {
        value = ColorX.SRGBtoLinear( value );
      }

      if ( source_modifier != null )
      {
        value = source_modifier.Sample( value );
      }

      if ( output_sRGB )
      {
        value = ColorX.LinearToSRGB( value );
      } 

      return value;
    }
  }
}