using System.Collections;
using System.Collections.Generic;
using Godot;
using System;
using System.Threading;
using System.Threading.Tasks;


namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class ColorCorrectionPreset:Resource
  {
    [Export]
    public _XX_ColorCorrectionModifier[] modifiers = [];

    [Export(PropertyHint.Range, "0,100 suffix:%")]
    public float amount = 100;

    public Color Process( Color color )
    {
      var originalColor = color;
      modifiers.ForEach(
        ( m )=>
        {
          if ( m == null )
          {
            return;
          }

          color = m.Apply( color ); 
        }
      );

      return ColorX.Lerp( originalColor, color, amount/100f );
    }
  }
}