using System.Collections;
using System.Collections.Generic;
using Godot;
using System;
using System.Threading;
using System.Threading.Tasks;


namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class Colorize:_XX_ColorCorrectionModifier
  { 
    [Export]
    public Color color;

    [Export]
    public Curve amountFromSourceLuminance = MathX.Curve( 0.1f );

    [Export(PropertyHint.Range, "0,100 suffix:%")]
    public float hueAmount = 100;

    [Export(PropertyHint.Range, "0,100 suffix:%")]
    public float saturationAmount = 100;

    [Export(PropertyHint.Range, "0,100 suffix:%")]
    public float luminanceAmount = 100;

    [Export]
    public bool blendHueInRGB = true; 

    protected override Color _Modify( Color sourceColor )
    {
      var sourceHSL = HSLColor.FromRGBA( sourceColor );
      var sourceLuminanceAmount = amountFromSourceLuminance.Sample( sourceHSL.l );

      var targetHSL = HSLColor.FromRGBA( color ); 

      var weights = new Vector4( hueAmount / 100f, saturationAmount / 100f, luminanceAmount / 100f, 1 );
      weights *= sourceLuminanceAmount;

      if ( blendHueInRGB )
      {
        targetHSL = HSLColor.LerpWithHueInRGB( sourceHSL, targetHSL, weights );
      }
      else
      {
        targetHSL = HSLColor.Lerp( sourceHSL, targetHSL, weights );
      }

      return targetHSL;
    }
  }
}