using System.Collections;
using System.Collections.Generic;
using Godot;
using System;
using System.Threading;
using System.Threading.Tasks;


namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class CrossCurves:_XX_ColorCorrectionModifier
  {
    

    [Export]
    public ColorChannelType driver;

    [Export]
    public ColorChannelType target;

    [Export]
    public Curve crossCurve;

    [Export]
    public bool normalize = true;

    protected override Color _Modify( Color color )
    {
      if ( crossCurve == null )
      {
        return color;
      }
      
      var valueIn = color.GetChannel( driver );

      if ( ColorChannelType.Hue == driver )
      {
        valueIn /= 360f;
      }

      var offsetValue = crossCurve.Sample( valueIn );

      if ( ColorChannelType.Hue == target )
      {
        offsetValue *= 360f;
      }

      var endValue = color.GetChannel( target ) + offsetValue;

      if ( ColorChannelType.Hue == target )
      {
        endValue = MathX.Repeat( endValue, 360 );
      }
      else
      {
        endValue = MathX.Clamp01( endValue );
      }

      color = color.SetChannel( target, endValue );

      return color;
    }

  
  }
}