using System.Collections;
using System.Collections.Generic;
using Godot;
using System;
using System.Threading;
using System.Threading.Tasks;


namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class HSLCurves:_XX_ColorCorrectionModifier
  {
    [Export]
    public Curve h = MathX.Curve( 0, 360, 0, 360, 0, 360 );

    [Export]
    public float hOffset = 0;

    [Export]
    public Curve s = MathX.Curve( 0, 1, 0, 1); 

    [Export]
    public float sOffset = 0;

    [Export]
    public Curve l = MathX.Curve( 0, 1, 0, 1); 

    [Export]
    public float lOffset = 0;

    protected override Color _Modify( Color color )
    {
      var hsl = HSLColor.FromRGBA( color );
      
      var hh = h == null ? hsl.h : h.Sample( hsl.h );
      var ss = s == null ? hsl.s : s.Sample( hsl.s );
      var ll = l == null ? hsl.l : l.Sample( hsl.l );
      
      hh += hOffset;
      ss += sOffset;
      ll += lOffset;

      hh = MathX.Repeat( hh, 360 );
      ss = MathX.Clamp01( ss );
      ll = MathX.Clamp01( ll );

      hsl.h = hh;
      hsl.s = ss;
      hsl.l = ll;
      
      return hsl.ToRGBA();
    }
  }
}