using System.Collections;
using System.Collections.Generic;
using Godot;
using System;
using System.Threading;
using System.Threading.Tasks;


namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class RGBCurves:_XX_ColorCorrectionModifier
  {
    [Export]
    public Curve r;

    [Export]
    public Curve g;

    [Export]
    public Curve b;

    protected override Color _Modify( Color color )
    {
      var rr = r == null ? color.R : r.Sample( color.R );
      var gg = g == null ? color.G : g.Sample( color.G );
      var bb = b == null ? color.B : b.Sample( color.B );
      
      return new Color( rr, gg, bb, color.A );
    }
  }
}