using System.Collections;
using System.Collections.Generic;
using Godot;
using System;
using System.Threading;
using System.Threading.Tasks;


namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class _XX_ColorCorrectionModifier:Resource
  { 
    [Export(PropertyHint.Range, "0,100 suffix:%")]
    public float amount = 100;

    [Export]
    public bool enabled = true;

    public Color Apply( Color color )
    {
      if ( ! enabled )
      {
        return color;
      }
      
      var modified = _Modify( color );

      return ColorX.Lerp( color, modified, amount / 100f );
    }

    protected virtual Color _Modify( Color color )
    {
      return color;
    }
  }
}