using System.Collections;
using System.Collections.Generic;
using Godot;
using System;
using System.Threading;
using System.Threading.Tasks;


namespace Rokojori
{
  public class TextureCombinerProcessingRect
  {
    public TextureCombinerContext context;
    public int processingX = 0;
    public int processingY = 0;
    public int processingWidth = 0;
    public int processingHeight = 0;


    public Vector2 GetUV( int x, int y )
    {
      return new Vector2( x / (float) context.imageWidth, y / (float) context.imageHeight );
    }

    public Vector2 GetRelativeUV( int x, int y )
    {
      return GetUV( x + processingX, y + processingY );
    }

    public void SetOutputRelative( int x, int y, Color c )
    {
      outputBuffer.SetAt( x + processingX, y + processingY, c );
    } 


    public Vector2 uvStart => GetUV( processingX, processingY );
    public Vector2 uvEnd   => GetUV( processingX + processingWidth, processingY + processingHeight );

    public TextureCombinerBuffer inputBuffer;
    public TextureCombinerBuffer outputBuffer;
    

    public async Task CopyToFinalOutput( TextureCombinerBuffer bottomBuffer, TextureCombinerBuffer image )
    {
      var time = Async.StartTimer();
      bottomBuffer.CopyTo( 0, 0, processingX, processingY, processingWidth, processingHeight, image );
      time = await Async.WaitIfExceeded( time );

      return; 
    }

  }
}