using System.Collections;
using System.Collections.Generic;
using Godot;
using System;



namespace Rokojori
{

  [Tool]
  [GlobalClass]
  public partial class TextureCombinerRunner:Node
  {    
    [Export]
    public TextureCombiner[] combiners;

    [Export]
    public bool run = false;

    [Export]
    public int processIndex = 1;

    [Export]
    public bool waitForFinish = false;


    public override void _Process( double delta )
    {
      if ( ! run || combiners == null || combiners.Length == 0 )
      {
        return;
      }

      for ( int i = 0; i < combiners.Length; i++ )
      {
        if ( combiners[ i ] == null )
        {
          return;
        }
      }

      processIndex = Mathf.Clamp( processIndex, 0, combiners.Length -1 );

      
      if ( combiners[ processIndex ]._creatingTexture || ! combiners[ processIndex ].autoCreate )
      {
        return;
      }
      
      if ( waitForFinish )
      {
        processIndex = MathX.SafeIndex( processIndex + 1, combiners, true );
      }

      waitForFinish = ! waitForFinish;
      combiners[ processIndex ].create = true;
    }
  }
}