using System.Collections;
using System.Collections.Generic;
using Godot;
using System;
using System.Text;



namespace Rokojori
{
  public class IDGenerator
  {
    static readonly string DefaultID_CharacterSet = 
      "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    static readonly int DefaultID_NumCharacters = 16;

    protected string characterSet = IDGenerator.DefaultID_CharacterSet;
    protected int numCharacters = DefaultID_NumCharacters;    



    public IDGenerator set( string characterSet, int numCharacters )
    {
      this.characterSet  = characterSet;
      this.numCharacters = numCharacters;
    
      return this;
    }

    public static string GenerateID( RandomEngine randomEngine = null )
    {
      var id = "";
      randomEngine = RandomEngine.CreateIfNull( randomEngine );
      
      for ( var i = 0; i < DefaultID_NumCharacters; i++ )
      {
        var randomCharacter = randomEngine.From( DefaultID_CharacterSet ); 
        id += randomCharacter;
      }

      return id;
    }

    public string generate( RandomEngine randomEngine = null )
    { 
      var id = new StringBuilder();
      randomEngine = RandomEngine.CreateIfNull( randomEngine );
      
      for ( var i = 0; i < numCharacters; i++ )
      {
        var randomCharacter = randomEngine.From( characterSet ); 
        id.Append( randomCharacter );
      }

      return id.ToString();
    }

  }
}