using System.Collections;
using System.Collections.Generic;
using Godot;
using System;



namespace Rokojori
{
  public class RandomList<T>
  {
    List<T> _list = new List<T>();
    int _pointer = 0;

    public T Next()
    {
      var element = _list[ _pointer ];
      _pointer = ( _pointer + 1 ) % _list.Count;

      return element;
    }

    public static List<T> Randomize( List<T> data, RandomEngine r )
    {
      return new RandomList<T>( data, r ).GetList();
    }

    public RandomList( List<T> data, RandomEngine r = null )
    {
      r = RandomEngine.CreateIfNull( r );
      var copy = new List<T>();
      copy.AddRange( data );

      while ( copy.Count > 0 )
      {
        _list.Add( r.RemoveFrom( copy ) );
      }
    }

    public List<T> GetList()
    {
      return _list;
    }

    
  }
}