
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;


namespace Rokojori.Reallusion
{  
  public class CCImportFile:CCImportFileBase
  {  
    public string name;

    public CCObjectInfo ccObject;
    public List<Message> messages = new List<Message>();
    public string path;

    public string directory => FilePath.Absolute( path ).CreateAbsoluteParent().fullPath;
    
    public CCImportFile():base( null )
    {
      _importFile = this;
    }

    public void _Error( params object[] items )
    {
      Messages.Error( messages, RJLog.GetLogString( items ) );
    }

    public void _Info( params object[] items )
    {
      Messages.Info( messages, RJLog.GetLogString( items ) );
    }

    public void ReadFrom( JSONData data )
    {
      if ( data == null  )
      {
        Error( "Root is null" );
        return;
      }

      if ( data.dataType != JSONDataType.OBJECT )
      {
        Error( "Invalid root, not an object, actual type: ", data.dataType );
        return;
      }


      var root = data.AsObject();

      if ( root.keys.Count == 0 )
      {
        Error( "Root has no children" );
        return;
      }

      if ( root.keys.Count > 1 )
      {
        Error( "Root has more than one child" );
        return;
      }
      
      var rootKey = root.keys[ 0 ];

      name = rootKey;

      Info( "Found root object:", name );

      var rootObject = root.GetObject( rootKey );

      var objectKey = "Object";

      if ( ! ValidateMember( rootObject, objectKey, "Checking cc object" ) )
      {
        return;
      }

      var objectData = rootObject.GetObject( objectKey );

      ccObject = new CCObjectInfo( this );

      
      ccObject.ReadFrom( objectData );

      
    }


    
  }
}