


namespace Rokojori.Reallusion
{  
  public class CCImportFileBase
  {  
    protected CCImportFile _importFile;
    public CCImportFile importFile => _importFile; 

   
    public CCImportFileBase( CCImportFile importFile )
    {
      _importFile = importFile;
    }

    public virtual void Error( params object[] items )
    {
      importFile._Error( items );
    }

    public virtual void Info( params object[] items )
    {
      importFile._Info( items );
    }


    public bool ValidateMember( JSONData parentNode, string name, string contextInfo, JSONDataType jsonType = JSONDataType.OBJECT )
    {
      if ( parentNode == null )
      {
        Error( contextInfo, "parent node is null" );
        return false;
      }

      if ( ! parentNode.isObject )
      {
        Error( contextInfo, "parent node is not an object" );
        return false;
      }

      if ( ! parentNode.isObject )
      {
        Error( contextInfo, "parent node is not an object" );
        return false;
      }

      var parentObject = parentNode.AsObject();

      if ( ! parentObject.HasKey( name ) )
      {
        Error( contextInfo, "parent node doesn't have the key:", name );
        return false;
      }

      var childData = parentObject.Get( name );

      if ( childData.dataType != jsonType )
      {
        Error( contextInfo, "node doesn't have the expected type " + jsonType, "it has:", childData.dataType );
        return false;
      }

      return true;
    }
  }
}