
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;

namespace Rokojori.Reallusion
{  
  public class CCJSONProperty<T> 
  {
    protected string _name;
    public string name => _name;

    public T value;
    public bool exists = false;

    protected Func<JSONData,T> _customReader;

    public CCJSONProperty( string name )
    {
      _name = name;
    }

    public void SetReader(Func<JSONData,T> reader = null )
    {
      _name = name;
      _customReader = reader;
    }


    public T GetOr( T alternative )
    {
      if ( ! exists )
      {
        return alternative;
      }

      return value;
    }

    

    


    public void Read( JSONObject root )
    { 
      if ( ! root.HasKey( _name ) )
      {
        exists = false;
        return;
      }

      var data = root.Get( _name );

      if ( _customReader != null )
      {
        Set( _customReader( data ) );
      } 
      else if ( Is( typeof( int ) ) )
      {
        Set( data.intValue );
      }
      else if ( Is( typeof( float ) ) )
      {
        Set( data.floatValue );
      }
      else if ( Is( typeof( string ) ) )
      {
        Set( data.stringValue );
      }
      else if ( Is( typeof( List<float> ) ) )
      {
        Set( data.AsArray().AsFloatList() );
      }

      exists = true;
    }

    void Set( object value )
    {
      this.value = (T) value;
    }

    bool Is( Type type )
    {
      return typeof( T ) == type;
    }

  }
}