
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;


namespace Rokojori.Reallusion
{  
  public class CCMeshInfo:CCImportFileBase
  {
    public static readonly string Materials = "Materials";

    public string name;

    public List<CCMaterialInfo> materials = [];

    public CCMeshInfo( CCImportFile ccImportFile ):base( ccImportFile ){}


    public void ReadFrom( JSONObject root )
    { 
      if ( ! ValidateMember( root, Materials, "Checking mesh info " + "'" + name + "'" ) )
      {
        return;
      }

      var materials = root.GetObject( Materials );

      Info( "Found materials for", "'" + name + "'", ":", materials.size );

      materials.keys.ForEach(
        ( mk )=>
        {
          var name = mk;
          var value = materials.GetObject( name );

          Info( "Adding material:", name );
          var materialInfo = new CCMaterialInfo( importFile, name );

          materialInfo.ReadFrom( value );

          this.materials.Add( materialInfo );
        }
      );
    }
  }
}