
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;


namespace Rokojori.Reallusion
{  
  public class CCObjectInfo:CCImportFileBase
  {  
    public static readonly string Meshes = "Meshes";

    public string name;

    public List<CCMeshInfo> meshes = [];

    public CCObjectInfo( CCImportFile ccImportFile ):base( ccImportFile ){}

    public void ReadFrom( JSONObject root )
    { 
      var rootKey = root.keys[ 0 ];

      name = rootKey;

      Info( "Found object entry:", name );

      if ( ! ValidateMember( root, rootKey, "Checking root object" ) )
      {
        return;
      }

      var rootObject = root.GetObject( rootKey );

      

      if ( ! ValidateMember( rootObject, CCObjectInfo.Meshes, "Checking root object meshes" ) )
      {
        return;
      }

      var meshes = rootObject.GetObject( CCObjectInfo.Meshes );

      Info( "Found meshes", meshes.size );

      meshes.keys.ForEach(
        ( mk )=>
        {
          var name = mk;
          var value = meshes.GetObject( mk );

          var meshInfo = new CCMeshInfo( importFile );
          meshInfo.name = name;

          meshInfo.ReadFrom( value );

          this.meshes.Add( meshInfo );

        }
      );
      
    } 
  }
}