
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;


namespace Rokojori.Reallusion
{  
  public class CCTextureInfo:CCImportFileBase
  {  
    public static readonly string BaseColor = "Base Color";
    public bool isBaseColor => Is( BaseColor );

    public static readonly string Opacity = "Opacity";
    public bool isOpacity => Is( Opacity );

    public static readonly string Metallic = "Metallic";
    public bool isMetallic => Is( Metallic );

    public static readonly string Roughness = "Roughness";
    public bool isRoughness => Is( Roughness );

    public static readonly string Normal = "Normal";
    public bool isNormal => Is( Normal );

    public static readonly string AO = "AO";
    public bool isAO => Is( AO );

    public static readonly string Glow = "Glow";
    public bool isGlow => Is( Glow );

    public static readonly string Blend = "Blend";
    public bool isBlend => Is( Blend );

    public string name;

    public CCJSONProperty<string> texturePath = new CCJSONProperty<string>( "Texture Path");

    public CCJSONProperty<float> strength = new CCJSONProperty<float>( "Strength");

    public CCJSONProperty<List<float>> offset = new CCJSONProperty<List<float>>( "Offset" );
    public CCJSONProperty<List<float>> tiling = new CCJSONProperty<List<float>>( "Tiling" );


    public CCTextureInfo( CCImportFile file, string name ):base( file )
    {
      this.name = name;
    }

    public Texture2D GetTexture()
    {
      var path = texturePath.value;
      return GetTextureFromRelativePath( path );
    }

    Texture2D GetTextureFromRelativePath( string relativePath )
    {
      var rootDirectoryPath = FilePath.Absolute( importFile.directory );
      var relativeFilePath = rootDirectoryPath.MakeRelative( relativePath );

      var texture = ResourceLoader.Load<Texture2D>( relativeFilePath.fullPath );

      return texture;

      // var img = new Image(); 
      // var result = img.Load( relativeFilePath.fullPath );
      
      // if ( result != Godot.Error.Ok )
      // {
      //   Error( "Could not load image:", relativePath, ">>", relativeFilePath.fullPath );
      //   return null;
      // } 

      // return ImageTexture.CreateFromImage( img );
    }

    public void ReadFrom( JSONObject jsonObject )
    {
      texturePath.Read( jsonObject );
      strength.Read( jsonObject );
      offset.Read( jsonObject );
      tiling.Read( jsonObject );
    }

    public bool Is( string type )
    {
      return name == type;
    }

    

    public static CCTextureInfo Create( CCImportFile file, string name, JSONData data )
    {
      var ti = new CCTextureInfo( file, name );

      ti.ReadFrom( data.AsObject() );

      return ti;
    }


  }
}