
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;
using System.Threading.Tasks;
using System.Text;

namespace Rokojori.Reallusion
{  
  [Tool]
  [GlobalClass]
  public partial class CCImportConfiguration:Resource
  {  

    

    [Export]
    public float gammaForAlbedoColor = 1.0f / 2.2f;

    [Export]
    public CCMaterialOverwrite[] materialOverwrites = [];

    [ExportGroup( "Skin")]
    [Export]
    public bool transmissiveSkin = true;

    public bool applyAlbedoNoise = true;
    
    [Export]
    public Texture2D skinAlbedoNoise;

    [Export]
    public float albedoNoiseBrightness = -0.5f;

    [Export]
    public float albedoNoiseAmount = 0.2f;

    public enum HairShaderMode
    {
      Alpha_Only,
      Scissor_AlphaBack_AlphaFront,
      Shadow_Scissor_AlphaBack_AlphaFront
    }

    [ExportGroup( "Hair")]
    [Export]
    public HairShaderMode  hairShaderMode = HairShaderMode.Scissor_AlphaBack_AlphaFront;

    [ExportGroup( "Hair/Render Order")]
    [Export]
    public bool setRenderPrioritiesForHair = true; 

    [Export]
    public CCMaterialTarget[] preRenderPriorityTargets = [];

    [ExportGroup( "Hair")]
    [Export(PropertyHint.Range,"0,1")]
    public float naturalColors = 0.5f;

    [Export(PropertyHint.Range,"0,1")]
    public float maximumHighlightAmount = 0.5f;

    [Export(PropertyHint.Range,"-1,1")]
    public float roughnessOffset = -0.1f;

    [Export(PropertyHint.Range,"-1,1")]
    public float metallicOffset = 0.0f;

    [Export]
    public float hairOpacityGamma = 1.2f;

    [Export]
    public float anisotropicRatio = 1.0f;

    [Export]
    public CCHairOpacityGammaOverwrite[] hairOpacityGammaOverwrites = [];

    public Material GetOverwriteMaterial( string name, int index )
    {
      var ov = Arrays.Find( materialOverwrites, mo => mo.meshName == name && mo.materialSurfaceIndex == index );

      return ov == null ? null : ov.material;
    }
    
    public float GetHairOpacityGamma( string meshName, int surfaceIndex )
    {
      if ( hairOpacityGammaOverwrites == null || hairOpacityGammaOverwrites.Length == 0 )
      {
        return hairOpacityGamma;
      }

      for ( int i = 0; i < hairOpacityGammaOverwrites.Length; i++ )
      {
        var overwriteTargets = hairOpacityGammaOverwrites[ i ].targets;
        
        for ( int j = 0; j < overwriteTargets.Length; j++ )
        {
          var target = overwriteTargets[ j ];

          if ( target.meshName == meshName && target.materialSurfaceIndex == surfaceIndex )
          {
            return hairOpacityGammaOverwrites[ i ].hairOpacityGamma;
          }
        }
      }


      return hairOpacityGamma;

    }
    
  }
}