
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;
using System.Threading.Tasks;
using System.Text;

namespace Rokojori.Reallusion
{  
  [Tool]
  [GlobalClass]
  public partial class CCMaterials:Node
  {  
    [Export]
    public Node3D root;

    [Export]
    public bool applyProperties = false;

    [ExportGroup("Hair")]
    [Export]
    public Material[] hairMaterials = [];

    [Export]
    public FloatProperty hairSpecular = FloatProperty.Create( "specular", 0 );
    [Export]
    public FloatProperty hairMetallic = FloatProperty.Create( "metallic", 0 );
    [Export]
    public FloatProperty hairRoughness = FloatProperty.Create( "roughness", 0 );

    void ApplyHairProperties()
    {
      Apply( hairMaterials, hairSpecular );
      Apply( hairMaterials, hairMetallic );
      Apply( hairMaterials, hairRoughness );
    }
    
    [ExportGroup("Skin")]
    [Export]
    public Material[] skinMaterials = [];

    [Export]
    public FloatProperty skinAlbedoNoise = FloatProperty.Create( "albedoNoise", 0 );
    [Export]
    public FloatProperty skinAlbedoNoiseOffset = FloatProperty.Create( "albedoNoiseOffset", 0 );

    void ApplySkinProperties()
    {
      Apply( skinMaterials, skinAlbedoNoise );
      Apply( skinMaterials, skinAlbedoNoiseOffset );
    }

    public void Clear()
    {
      root = null;
      hairMaterials = [];
      skinMaterials = [];
    } 

    public override void _Process( double delta )
    {
      if ( ! applyProperties )
      {
        return;
      }
      
      ApplyHairProperties();
      ApplySkinProperties();
    } 

    void Apply( Material[] materials, ShaderProperty sp )
    {
      for ( int i = 0; i < materials.Length; i++ )
      {
        sp.Apply( materials[ i ] );
      }
    }
  }
}