using System.Collections;
using System.Collections.Generic;
using Godot;
using System;
using System.Threading.Tasks;



namespace Rokojori
{
  /** <summary for="class CustomMaterialOverride">
      
      <title>
        Resource to create foliage material overrides with custom materials
      </title>
      
      <description>
        
      </description>

    </summary>  
  */

  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/Scatterer.svg") ]
  public partial class CustomMaterialOverride:FoliageMaterialOverride
  {    
    [Export]
    public Material customMaterial;

    [Export]
    public bool createDuplicate = true;

    public override void CreateFoliageOverideMaterial( FoliageRenderLayer foliageRenderLayer )
    {
      var gpuParticles3D = foliageRenderLayer.gpuParticles3D;

      var overrideMaterial = createDuplicate ? (Material)customMaterial.Duplicate() : customMaterial;
      gpuParticles3D.MaterialOverride = overrideMaterial;

      UpdateFoliageOverideMaterial( foliageRenderLayer );
    }

    public override void UpdateFoliageOverideMaterial( FoliageRenderLayer foliageRenderLayer )
    {

    }

    public override Material GetOverrideMaterial( FoliageRenderLayer foliageRenderLayer )
    {      
      var material = foliageRenderLayer.gpuParticles3D.MaterialOverride;
      return material;
    }
  }
}