using System.Collections;
using System.Collections.Generic;
using Godot;
using System;
using System.Threading.Tasks;



namespace Rokojori
{
  /** <summary for="class FoliageTextureOverride">
      
      <title>
        Abstract archetype resource to create foliage texture overrides
      </title>
      
      <description>
        
      </description>

    </summary>  
  */

  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/Scatterer.svg") ]
  public partial class FoliageTextureOverride:Resource
  {
    public enum OverrideTarget
    {
      Albedo,
      Normal,
      Roughness,
      Metallic,
      Occlusion,
      Specular,
      Emission
    }

    [Export]
    public OverrideTarget target;

    [Export]
    public Texture2D texture2D;

    [Export]
    public bool assignValue = false;
    
    [Export]
    public Color color;

    public void Apply( Material material )
    {
      if ( OverrideTarget.Albedo == target )
      {
        ApplyAlbedo( material );
      }
      else if ( OverrideTarget.Normal == target )
      {
        ApplyNormal( material );
      }
      else if ( OverrideTarget.Roughness == target )
      {
        ApplyRoughness( material );
      }
      else if ( OverrideTarget.Metallic == target )
      {
        ApplyMetallic( material );
      }
      else if ( OverrideTarget.Occlusion == target )
      {
        ApplyOcclusion( material );
      }
      else if ( OverrideTarget.Specular == target )
      {
        ApplySpecular( material );
      }
      else if ( OverrideTarget.Emission == target )
      {
        ApplyEmission( material );
      }
    }


    void ApplyAlbedo( Material material )
    {
      if ( material is StandardMaterial3D sm )
      {
        if ( assignValue )
        {
          sm.AlbedoColor = color;
        }

        if ( texture2D != null )
        {
          sm.AlbedoTexture = texture2D;
        }
      }
    }

    void ApplyNormal( Material material )
    {

      if ( material is StandardMaterial3D sm )
      {
        sm.NormalEnabled = true;

        if ( assignValue )
        {
          sm.NormalScale = color.R;
        }

        if ( texture2D != null )
        {
          sm.NormalTexture = texture2D;
        }
      }
    }

    void ApplyRoughness( Material material )
    {
      if ( material is StandardMaterial3D sm )
      {
        if ( assignValue )
        {
          sm.Roughness = color.R;
        }

        if ( texture2D != null )
        {
          sm.RoughnessTexture = texture2D;
        }
      }
    }

    void ApplyMetallic( Material material )
    {
      if ( material is StandardMaterial3D sm )
      {
        if ( assignValue )
        {
          sm.Metallic = color.R;
        }

        if ( texture2D != null )
        {
          sm.MetallicTexture = texture2D;
        }
      }
    }


    void ApplyOcclusion( Material material )
    {
      if ( material is StandardMaterial3D sm )
      {
        sm.AOEnabled = true;

        if ( assignValue )
        {
          sm.AOLightAffect = color.R;
          
        }

        if ( texture2D != null )
        {
          sm.AOTexture = texture2D;
        }
      }
    }

    void ApplySpecular( Material material )
    {
      if ( material is StandardMaterial3D sm )
      {
        if ( assignValue )
        {
          sm.MetallicSpecular = color.R;
          
        }

      }
    }

    void ApplyEmission( Material material )
    {
      if ( material is StandardMaterial3D sm )
      {
        sm.EmissionEnabled = true;
        if ( assignValue )
        {
          sm.EmissionIntensity = color.R;
        }

        if ( texture2D != null )
        {
          sm.EmissionTexture = texture2D;
        }
      }
    }


  }
}