using System.Collections;
using System.Collections.Generic;
using Godot;
using System;
using System.Threading.Tasks;



namespace Rokojori
{
  /** <summary for="class BasicFoliageTranslucencySettings">
      
      <title>
        FoliageTranslucencySettings to setup the foliage translucency
      </title>
      
      <description>
        
      </description>

    </summary>  
  */

  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/Scatterer.svg") ]
  public partial class BasicFoliageTranslucencySettings:FoliageTranslucencySettings
  {
    [Export(PropertyHint.Range,"0,1")]
    public float translucency = 0.5f;

    public override void ApplyTranslucency( Material material, FoliageRenderLayer layer )
    {
      if ( material is StandardMaterial3D sm )
      {
        sm.SubsurfScatterEnabled = translucency > 0;
        sm.SubsurfScatterTransmittanceEnabled = translucency > 0;
        sm.BacklightEnabled = translucency > 0;

        if ( translucency > 0 )
        {
          sm.SubsurfScatterStrength = Mathf.Pow( translucency, 0.6f );
          sm.SubsurfScatterTransmittanceDepth = Mathf.Pow( translucency, 0.6f ) * 8f;
          sm.SubsurfScatterSkinMode = true;
          sm.SubsurfScatterTransmittanceBoost = 1.0f;          

          var bl = Mathf.Pow( translucency, 2f );

          sm.Backlight = new Color( bl, bl, bl );
        }
      }
    }
  }
}