using System.Collections;
using System.Collections.Generic;
using Godot;
using System;
using System.Threading.Tasks;



namespace Rokojori
{
  /** <summary for="class BasicFoliageTransparencyRenderMode">
      
      <title>
        FoliageTransparencyRenderMode to setup transparency quickly
      </title>
      
      <description>
        
      </description>

    </summary>  
  */

  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/Scatterer.svg") ]
  public partial class BasicFoliageTransparencyRenderMode:FoliageTransparencyRenderMode
  {
    public enum BasicFoliageTransparencyRenderModeType
    {
      OpaqueQueue_Scissor_Soft,
      OpaqueQueue_Scissor_Middle,
      OpaqueQueue_Scissor_Sharp,
      TransparentQueue_Scissor_Soft,
      TransparentQueue_Scissor_Middle,
      TransparentQueue_Scissor_Sharp,
      TransparentQueue_Alpha_Prepass,
      TransparentQueue_Alpha_Only
    }

    [Export]
    public BasicFoliageTransparencyRenderModeType type;
 
    [Export]
    public BaseMaterial3D.TextureFilterEnum textureFilter = BaseMaterial3D.TextureFilterEnum.LinearWithMipmaps;



    public override void ApplyTransparencyMode( Material material, FoliageRenderLayer layer)
    {
      if ( material is StandardMaterial3D sm )
      {
        if ( sm.Transparency == BaseMaterial3D.TransparencyEnum.Disabled )
        {
          return;
        } 

        sm.TextureFilter = textureFilter;

        if ( BasicFoliageTransparencyRenderModeType.TransparentQueue_Alpha_Prepass == type )
        {
          sm.Transparency = BaseMaterial3D.TransparencyEnum.AlphaDepthPrePass;
        }
        else if ( BasicFoliageTransparencyRenderModeType.TransparentQueue_Alpha_Only == type )
        {
          sm.Transparency = BaseMaterial3D.TransparencyEnum.Alpha; 
        }
        else 
        {
          sm.Transparency = BaseMaterial3D.TransparencyEnum.AlphaScissor;

          if ( 
            BasicFoliageTransparencyRenderModeType.OpaqueQueue_Scissor_Soft == type ||
            BasicFoliageTransparencyRenderModeType.TransparentQueue_Scissor_Soft == type 
          )
          {
            var isOpaque = BasicFoliageTransparencyRenderModeType.OpaqueQueue_Scissor_Soft == type;
            sm.AlphaScissorThreshold = isOpaque ? 0.02f : 0.0f;
            sm.AlphaAntialiasingMode = isOpaque ? BaseMaterial3D.AlphaAntiAliasing.Off : BaseMaterial3D.AlphaAntiAliasing.AlphaToCoverageAndToOne;
            sm.AlphaAntialiasingEdge = 0.1f;
          }
          else if ( 
            BasicFoliageTransparencyRenderModeType.OpaqueQueue_Scissor_Middle == type ||
            BasicFoliageTransparencyRenderModeType.TransparentQueue_Scissor_Middle == type 
          )
          {
            var isOpaque = BasicFoliageTransparencyRenderModeType.OpaqueQueue_Scissor_Middle == type;
            sm.AlphaScissorThreshold = isOpaque ? 0.1f : 0.02f;
            sm.AlphaAntialiasingMode = isOpaque ? BaseMaterial3D.AlphaAntiAliasing.Off : BaseMaterial3D.AlphaAntiAliasing.AlphaToCoverageAndToOne;
            sm.AlphaAntialiasingEdge = 0.2f;
          }
          else if ( 
            BasicFoliageTransparencyRenderModeType.OpaqueQueue_Scissor_Sharp == type ||
            BasicFoliageTransparencyRenderModeType.TransparentQueue_Scissor_Sharp == type 
          )
          {
            var isOpaque = BasicFoliageTransparencyRenderModeType.OpaqueQueue_Scissor_Sharp == type;
            sm.AlphaScissorThreshold = isOpaque ? 0.2f : 0.1f;
            sm.AlphaAntialiasingMode = isOpaque ? BaseMaterial3D.AlphaAntiAliasing.Off : BaseMaterial3D.AlphaAntiAliasing.AlphaToCoverageAndToOne;
            sm.AlphaAntialiasingEdge = 0.3f;
          }
        }
      }
    }

    
  }
}