using System.Collections;
using System.Collections.Generic;
using Godot;
using System;
using System.Threading.Tasks;



namespace Rokojori
{
  /** <summary for="class SceneFoliageSource">
      
      <title>
        A FoliageSource that loads the foliage from the first MeshInstance of a loaded SceneReference.
      </title>
      
      <description>       

      </description>

    </summary>  
  */

  [Tool]
  [GlobalClass]
  public partial class SceneFoliageSource:FoliageSource
  { 
    [Export]
    public SceneReference sceneReference;

    public override void SetupFoliageDrawPass( FoliageRenderLayer renderLayer )
    {
      var particles = renderLayer.gpuParticles3D;

      // renderLayer.gpuParticles3D = particles;

      // var processMaterial = new GPUFoliageShaderMaterial();
      // particles.ProcessMaterial = processMaterial;
      // particles.Lifetime = 0.01f;
      // particles.Explosiveness = 1f;
      // particles.FixedFps = 0;
      // particles.Interpolate = false;
      // particles.FractDelta = false;

      // particles.CustomAabb = Box3.WithSize( 10000 );

      // processMaterial.positionVariance.Set( renderLayer.renderer.noise );
      // processMaterial.rotationVariance.Set( renderLayer.renderer.noise );
      // processMaterial.scaleVariance.Set( renderLayer.renderer.noise );
      // processMaterial.occupancyVariance.Set( renderLayer.renderer.noise );

      // renderLayer.gpuFoliageShaderMaterial = processMaterial;

      var packedScene = sceneReference.LoadScene();
      var sceneRoot = packedScene.Instantiate();

      

      var meshInstance = sceneRoot.GetSelfOrChildOf<MeshInstance3D>();

      this.LogInfo( packedScene, sceneRoot, meshInstance );
      particles.DrawPasses = 1;
      particles.DrawPass1 = meshInstance.Mesh;

      // particles.CastShadow = renderLayer.data.shadows ? GeometryInstance3D.ShadowCastingSetting.On : GeometryInstance3D.ShadowCastingSetting.Off;

    }
  }
}