
using Godot;
using Godot.Collections;
using System.Collections.Generic;
using System.Threading.Tasks;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public abstract partial class AlphaGrabTestEffect:SingleShaderCompositorEffect
  {
    public static readonly string shaderPath = Path( "AlphaGrabTest/AlphaGrabTestShader.glsl" );   

    protected override void OnConfigure()
    {
      EffectCallbackType = EffectCallbackTypeEnum.PostTransparent;
      _shaderPath = shaderPath;
      _groupSize = 32;
    }

    RDTexture _bufferTexture;
    RDTexture _copyTexture;

    bool _grabFlag;
    byte[] _data;
    bool _ready = false;
    bool _canDraw = true;

    public async Task<Texture2D> GetImageTexture( System.Func<Task> waiter )
    {
      var fmt = _bufferTexture.format;
      var imgF = Image.Format.Rgbah;

      var data = context.renderingDevice.TextureGetData( _bufferTexture.rid, 0 );
      var image = Image.CreateFromData( (int) fmt.Width, (int)fmt.Height, false, imgF, data );
    
      return ImageTexture.CreateFromImage( image );
      
    }

    protected override void SetConstants()
    {     
      // constants.Set(
      //   center, 
      //   radius, 
      //   intensity,
      //   samples,
      //   Vector2.Zero
      // );
    }
    
    protected override void RenderView()
    {     
      _bufferTexture = RDTexture.EnsureScreenSizeTexture( _bufferTexture, context );
      _copyTexture   = RDTexture.EnsureScreenSizeTexture( _copyTexture, context );

      context.AssignScreenColorTexture();
      context.AssignTexture( _bufferTexture );
      

      // context.pushConstants = constants;

      context.ProcessComputeProgram();

    }
  }
}